/*
 * Decompiled with CFR 0.152.
 */
package exploit.conversion;

import exploit.conversion.RBase;
import exploit.conversion.RNode;
import java.util.Vector;

public class RGraph {
    private Vector nodes = new Vector();
    private Vector normalList = new Vector();
    private boolean easy;
    private boolean closedPath = false;
    private int myID;
    private int aliveCount;

    public RGraph(boolean bl) {
        this.easy = bl;
        this.aliveCount = 0;
    }

    public void setID(int n) {
        this.myID = n;
    }

    public int getID() {
        return this.myID;
    }

    public RNode addToNodeLibrary(RBase rBase) {
        ++this.aliveCount;
        RNode rNode = new RNode(rBase, this.nodes.size(), this);
        this.nodes.add(rNode);
        return rNode;
    }

    public RNode addToNodeLibrary(RBase rBase, int n) {
        ++this.aliveCount;
        RNode rNode = new RNode(rBase, n, this);
        this.nodes.add(rNode);
        return rNode;
    }

    public void resetNodes() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RNode rNode = (RNode)this.nodes.get(i);
            rNode.reset();
        }
    }

    public void cleanNodes() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RNode rNode = (RNode)this.nodes.get(i);
            rNode.clean();
        }
    }

    public void buildConnections() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RNode rNode = (RNode)this.nodes.get(i);
            if (!rNode.isAlive()) continue;
            for (int j = 0; j < this.nodes.size(); ++j) {
                RNode rNode2;
                if (j == i || !(rNode2 = (RNode)this.nodes.get(j)).isAlive() || !rNode.getObject().connect(rNode2.getObject(), this.easy)) continue;
                rNode.addChild(rNode2);
                rNode2.addParent(rNode);
            }
        }
    }

    public RNode getNormalNode(boolean bl) {
        RNode rNode = null;
        RNode rNode2 = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            RNode rNode3 = (RNode)this.nodes.get(i);
            if (!rNode3.isAlive() || !rNode3.isNormal()) continue;
            if (rNode2 == null) {
                rNode2 = rNode3;
                if (!bl) {
                    return rNode2;
                }
            }
            if (rNode != null || rNode3.getParentCount() != 1) continue;
            rNode = rNode3;
        }
        if (bl && rNode != null) {
            rNode2 = rNode;
        }
        return rNode2;
    }

    public int aliveCount() {
        return this.aliveCount;
    }

    public int aliveLineCount() {
        return this.aliveCount;
    }

    public void destroy() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RNode rNode = (RNode)this.nodes.get(i);
            rNode.lockdown();
            --this.aliveCount;
        }
    }

    public void printOutNodeInformation() {
        System.out.println("\nGraph Information");
        for (int i = 0; i < this.nodes.size(); ++i) {
            int n;
            RNode rNode = (RNode)this.nodes.get(i);
            System.out.println("\tNode: " + rNode.getID() + " : " + rNode.isAlive() + (rNode.isNormal() ? " Normal " : " Wrong ") + rNode.getObject());
            for (n = 0; n < rNode.getChildCount(); ++n) {
                System.out.println("\t\tChild: " + rNode.getChild(n).getID());
            }
            for (n = 0; n < rNode.getParentCount(); ++n) {
                System.out.println("\t\tParent: " + rNode.getParent(n).getID());
            }
        }
    }

    public boolean isClosedPath() {
        return this.closedPath;
    }

    public RNode findNode(RBase rBase) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            RNode rNode = (RNode)this.nodes.get(i);
            if (rNode.getObject() != rBase) continue;
            return rNode;
        }
        return null;
    }

    public RNode findUseableFillPath(RNode rNode) {
        int n;
        boolean bl = false;
        RNode rNode2 = null;
        RNode rNode3 = null;
        if (rNode == null && (rNode = this.getNormalNode(true)) == null) {
            return null;
        }
        Vector vector = new Vector();
        Vector<RNode> vector2 = new Vector<RNode>();
        Vector vector3 = new Vector();
        for (n = 0; n < rNode.getChildCount(); ++n) {
            rNode.getChild((int)n).parent = rNode;
            vector2.add(rNode.getChild(n));
        }
        while (vector2.size() > 0) {
            vector3 = vector;
            vector = vector2;
            vector2 = vector3;
            block2: for (n = 0; n < vector.size(); ++n) {
                rNode2 = (RNode)vector.get(n);
                for (int i = 0; i < rNode2.getChildCount(); ++i) {
                    rNode3 = rNode2.getChild(i);
                    if (rNode3.parent != null) continue;
                    if (rNode3.getID() == rNode.getID()) {
                        bl = true;
                        while (rNode2.getID() != rNode.getID()) {
                            rNode2.lockdown();
                            --this.aliveCount;
                            rNode2.parent.child = rNode2;
                            rNode2 = rNode2.parent;
                        }
                        --this.aliveCount;
                        rNode.lockdown();
                        vector2.clear();
                        vector.clear();
                        continue block2;
                    }
                    rNode3.parent = rNode2;
                    vector2.add(rNode3);
                }
            }
            vector.clear();
        }
        if (!bl) {
            rNode.lockdown();
            --this.aliveCount;
            if (!rNode.getObject().connect(rNode.getObject(), this.easy)) {
                rNode = null;
            }
        }
        return rNode;
    }

    public RNode findUseableLinePath(RNode rNode) {
        boolean bl = false;
        this.closedPath = false;
        RNode rNode2 = null;
        RNode rNode3 = null;
        RNode rNode4 = null;
        if (rNode == null && (rNode = this.getNormalNode(true)) == null) {
            for (int i = 0; !(i >= this.nodes.size() || (rNode = (RNode)this.nodes.get(i)) != null && rNode.isAlive()); ++i) {
                rNode = null;
            }
        }
        if (rNode == null) {
            return null;
        }
        Vector vector = new Vector();
        Vector<RNode> vector2 = new Vector<RNode>();
        Vector vector3 = new Vector();
        vector2.add(rNode);
        rNode2 = rNode;
        while (vector2.size() > 0) {
            vector3 = vector;
            vector = vector2;
            vector2 = vector3;
            for (int i = 0; i < vector.size(); ++i) {
                rNode3 = (RNode)vector.get(i);
                for (int j = 0; j < rNode3.getChildCount(); ++j) {
                    rNode2 = rNode4 = rNode3.getChild(j);
                    if (rNode4.parent != null) continue;
                    if (rNode4.getID() == rNode.getID()) {
                        rNode3.flag = true;
                        bl = true;
                        this.closedPath = true;
                        while (rNode3.getID() != rNode.getID()) {
                            rNode3.lockdown();
                            --this.aliveCount;
                            rNode3.parent.child = rNode3;
                            rNode3 = rNode3.parent;
                        }
                        rNode.lockdown();
                        --this.aliveCount;
                        rNode.flag = true;
                        return rNode;
                    }
                    rNode4.parent = rNode3;
                    vector2.add(rNode4);
                }
            }
            vector.clear();
        }
        if (rNode2 != null) {
            while (rNode2.getID() != rNode.getID()) {
                rNode2.lockdown();
                --this.aliveCount;
                rNode2.parent.child = rNode2;
                rNode2 = rNode2.parent;
            }
        }
        rNode.lockdown();
        --this.aliveCount;
        return rNode;
    }

    public int removeChain(RNode rNode) {
        return this.removeChain(rNode, false);
    }

    public int removeChain(RNode rNode, boolean bl) {
        RNode rNode2 = rNode;
        Object var4_4 = null;
        int n = -1;
        if (bl) {
            n = rNode.getID();
        }
        Vector<RNode> vector = new Vector<RNode>();
        Vector<RNode> vector2 = new Vector<RNode>();
        vector.add(rNode);
        while (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                RNode rNode3 = (RNode)vector.get(i);
                rNode3.parent = null;
                for (int j = 0; j < rNode3.getChildCount(); ++j) {
                    RNode rNode4 = rNode3.getChild(j);
                    if (rNode4.parent != rNode3) continue;
                    vector2.add(rNode4);
                    rNode4.parent = null;
                }
                if (rNode3.child == null && !rNode3.flag) continue;
                if (bl) {
                    if (rNode3.getID() < n) {
                        n = rNode3.getID();
                    }
                } else if (rNode3.getID() > n) {
                    n = rNode3.getID();
                }
                rNode3.parent = null;
                rNode3.child = null;
                rNode3.wipe();
            }
            vector.clear();
            Vector<RNode> vector3 = vector;
            vector = vector2;
            vector2 = vector3;
        }
        rNode.parent = null;
        rNode.child = null;
        rNode.wipe();
        return n;
    }
}

